#version 330

#if _DIFFUSE_MAP
#if _ARRAY_TEXTURES
uniform sampler2DArray diffuseArray;
#else
uniform sampler2D diffuseMap;
#endif
#endif
#if _ALPHA_MAP
uniform sampler2D alphaMap;
#endif
#if _SPECULAR_MAP
uniform sampler2D specularMap;
#endif
#ifndef _SPECULAR_MAP
uniform vec4 specular;
#endif
#if _NORMAL_MAP
uniform sampler2D normalMap;
#endif
uniform float shininess;
uniform vec4 lightPosition;
#ifndef _GBUFFER
uniform vec4 ambient;
#else
uniform float farClip;
#endif

in vec4 pos;
in vec3 uv;
in vec3 norm;
in vec4 vcolor;
#if _NORMAL_MAP
in vec3 tang;
in vec3 binorm;
#endif

#if _GBUFFER
out vec4 oColor0;
out vec4 oColor1;
#else
out vec4 oColor;
#endif

#if _NORMAL_MAP
vec3 expand(vec3 v) {
	return (v - 0.5)*2.0;
}
#endif

vec2 encodeNormal(vec3 n)
{
    float p = sqrt(n.z*8 + 8);
    return vec2(n.xy/p + 0.5);
}

void main()
{
	vec2 dx = dFdx(uv.xy);
	vec2 dy = dFdy(uv.xy);
#if _ALPHA_MAP
	if(textureGrad(alphaMap, uv.xy, dx, dy).r < 0.5) discard;
#endif
	//vec3 paletteColor = palCol(int(uv.w));
	vec3 paletteColor = vcolor.rgb;
#if _DIFFUSE_MAP
#if _ARRAY_TEXTURES
	vec4 texColor = textureGrad(diffuseArray, uv.xyz, dx, dy);
#else
	vec4 texColor = textureGrad(diffuseMap, uv.xy, dx, dy);
#endif
	vec3 diffuse = mix(paletteColor, texColor.rgb, texColor.a);
#else
	vec3 diffuse = paletteColor;
#endif
#if _NORMAL_MAP
	vec3 N_ts = expand(textureGrad(normalMap, uv.xy, dx, dy).xyz);
	vec3 N = normalize(tang*N_ts.x + binorm*N_ts.y + norm*N_ts.z);
#else
	vec3 N = normalize(norm.xyz);
#endif

#if _ALPHA_MAP
	if(gl_FrontFacing) {
		N = -N;
	}
#endif


#if _SPECULAR_MAP
	vec4 specular = textureGrad(specularMap, uv.xy, dx, dy);
	float specularPower = shininess*specular.g;
#else
	float specularPower = shininess;
#endif

#ifdef _GBUFFER
	oColor0 = vec4(encodeNormal(N), pos.z/farClip, 0.0);
	oColor1 = vec4(diffuse.rgb, specular.r);
#else
	vec3 LightDir = normalize(lightPosition.xyz);
	float NdotL = dot(LightDir, N);
	vec3 EyeDir = normalize(-pos.xyz);
	float Rim = clamp(pow(1 - abs(dot(EyeDir, N)), 2)*0.5, 0.0, 1.0);
	vec3 HalfAngle = normalize(LightDir + EyeDir);
	float NdotH = dot(HalfAngle, N);
	vec4 Lit = vec4(1.0, max(NdotL, 0.0), (NdotL > 0) ? pow(max(0.0, NdotH), specularPower) : 0, 1.0);
	
	oColor = vec4(clamp(diffuse.rgb*(ambient.rgb + vec3(Lit.y)) + vec3(specular.r*(Lit.z + Rim)), 0.0, 1.0), 1.0);
#endif
}
